
-- Rain parameters
kPPS = 600;               -- Number of particles generated per second
kGravity = 700 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("confetti");
  SetBlendMode(kBlendNormal);
  SetNumParticles(5);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(500);
TestDone = NewTimeout(2500);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-10,-10,0), Vec3(10,10,0) );
   InitVelocity( "vRange", Vec3(-100,-200,0), Vec3(100, -350, 0));
   InitScale( "fRange", 0.5, 1 );
   InitAge("iRange", 0, 0);
   InitExtra1("fRange",0,1);
   CreateParticles(5);
  end

  Gravity(kGravity);

   Do("move");
   DoAge("iAge");
   DoScale("fScale",
      .5, 200, 
      1, 1500,
      .0, 1000);
   Do("expire", 2000)

   DoUp( "vRotate", -.6, .6 );


end

